<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_IGallery')):

    /**
     * Elementor Image Gallery Widget.
     *
     * @class BLOGINAC_Elementor_Image_Gallery
     * @version 1.1.0
     */
    class BLOGINAC_Elementor_IGallery extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-image-gallery';
        }

        public function get_title()
        {
            return __('Blogina Image Gallery', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-images';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Gallery Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Gallery Images Control
            $this->add_control(
                'gallery_images',
                [
                    'label' => __('Gallery Images', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::GALLERY,
                    'default' => [],
                ]
            );

            // Layout Options
            $this->add_control(
                'layout',
                [
                    'label' => __('Layout', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'grid',
                    'options' => [
                        'grid' => __('Grid', BLOGINAC_TEXT_DOMAIN),
                        'masonry' => __('Masonry', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            // Grid and Masonry Column Control
            $this->add_control(
                'columns',
                [
                    'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => '4',
                    'options' => [
                        '1' => __('1 Column', BLOGINAC_TEXT_DOMAIN),
                        '2' => __('2 Columns', BLOGINAC_TEXT_DOMAIN),
                        '3' => __('3 Columns', BLOGINAC_TEXT_DOMAIN),
                        '4' => __('4 Columns', BLOGINAC_TEXT_DOMAIN),
                        '5' => __('5 Columns', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'condition' => [
                        'layout' => ['grid', 'masonry'],
                    ],
                ]
            );

            // Spacing Control
            $this->add_control(
                'spacing',
                [
                    'label' => __('Spacing Between Images', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-gallery-wrapper' => 'grid-gap: {{SIZE}}px;',
                    ],
                ]
            );

            // Hover Effect
            $this->add_control(
                'hover_effect',
                [
                    'label' => __('Hover Effect', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'zoom',
                    'options' => [
                        'zoom' => __('Zoom', BLOGINAC_TEXT_DOMAIN),
                        'fade' => __('Fade', BLOGINAC_TEXT_DOMAIN),
                        'none' => __('None', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            // Enable Lightbox
            $this->add_control(
                'lightbox',
                [
                    'label' => __('Enable Lightbox', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'yes',
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Gallery Item Border Radius
            $this->add_control(
                'border_radius',
                [
                    'label' => __('Image Border Radius', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 5,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-gallery-item img' => 'border-radius: {{SIZE}}px;',
                    ],
                ]
            );

            // Image Caption Style
            $this->add_control(
                'caption_style',
                [
                    'label' => __('Caption Style', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => 'text-align: center; color: #fff;',
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $gallery_images = $settings['gallery_images'];
            $layout = $settings['layout'];
            $columns = $settings['columns'];
            $spacing = $settings['spacing']['size'] ?? 10;
            $hover_effect = $settings['hover_effect'];
            $lightbox = $settings['lightbox'] === 'yes' ? true : false;
            $caption_style = $settings['caption_style'];

            // Add classes for layout and column setting
            $layout_class = $layout === 'grid' ? 'bloginac-grid' : 'bloginac-masonry';
            $columns_class = 'bloginac-columns-' . $columns;

            // Start Gallery HTML
            echo '<div class="bloginac-gallery-wrapper ' . esc_attr($layout_class) . ' ' . esc_attr($columns_class) . '" style="grid-gap: ' . esc_attr($spacing) . 'px;">';

            foreach ($gallery_images as $image) {
                $image_url = $image['url'];
                $image_caption = $image['caption'] ?? 'Caption';

                // Lightbox support
                $lightbox_attr = $lightbox ? 'data-fancybox="gallery"' : '';

                echo '<div class="bloginac-gallery-item" style="position: relative;">';
                echo '<a href="' . esc_url($image_url) . '" ' . $lightbox_attr . '>';
                echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($image_caption) . '" class="gallery-img">';

                if ($hover_effect === 'zoom') {
                    echo '<style>
                            .bloginac-gallery-item:hover .gallery-img {
                                transform: scale(1.1);
                            }
                          </style>';
                } elseif ($hover_effect === 'fade') {
                    echo '<style>
                            .bloginac-gallery-item:hover .gallery-img {
                                opacity: 0.8;
                            }
                          </style>';
                }

                echo '</a>';

                // Display caption
                if ($image_caption) {
                    echo '<div class="gallery-caption" style="' . esc_attr($caption_style) . '">' . esc_html($image_caption) . '</div>';
                }

                echo '</div>';
            }

            echo '</div>';
        }
    }

endif;
