<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_FAQ')):

    /**
     * Elementor FAQ.
     *
     * @class BLOGINAC_Elementor_FAQ
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_FAQ extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-faq-widget';
        }

        public function get_title()
        {
            return __('Blogina FAQ', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-list-ul';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('FAQ Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // FAQ Control (Repeater for Questions and Answers)
            $this->add_control(
                'faq_list',
                [
                    'label' => __('FAQs', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'question',
                            'label' => __('Question', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('What is Elementor?', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'answer',
                            'label' => __('Answer', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => __('Elementor is a page builder for WordPress.', BLOGINAC_TEXT_DOMAIN),
                        ]
                    ],
                    'default' => [],
                ]
            );

            // Accordion or Toggle Style Control
            $this->add_control(
                'style',
                [
                    'label' => __('FAQ Style', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'accordion',
                    'options' => [
                        'accordion' => __('Accordion', BLOGINAC_TEXT_DOMAIN),
                        'toggle' => __('Toggle', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            // Spacing between FAQs
            $this->add_control(
                'spacing',
                [
                    'label' => __('Spacing Between Items', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-faq-item' => 'margin-bottom: {{SIZE}}px;',
                    ],
                ]
            );

            // Enable/Disable FAQ Icon
            $this->add_control(
                'enable_icon',
                [
                    'label' => __('Enable Icon', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'yes',
                ]
            );

            // Icon Style (Only if enabled)
            $this->add_control(
                'icon_color',
                [
                    'label' => __('Icon Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#333',
                    'condition' => [
                        'enable_icon' => 'yes',
                    ],
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('FAQ Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Question Text Style

            // Answer Text Style


            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $faq_list = $settings['faq_list'];
            $style = $settings['style'];
            $spacing = $settings['spacing']['size'] ?? 10;
            $enable_icon = $settings['enable_icon'];
            $icon_color = $settings['icon_color'];

            // Start FAQ HTML
            echo '<div class="bloginac-faq-wrapper">';

            foreach ($faq_list as $faq) {
                $question = $faq['question'];
                $answer = $faq['answer'];
                $question_id = sanitize_title($question);

                // Display FAQ item
                echo '<div class="bloginac-faq-item" style="margin-bottom: ' . esc_attr($spacing) . 'px;">';

                // Question
                echo '<div class="faq-question" id="' . esc_attr($question_id) . '">';
                if ($enable_icon === 'yes') {
                    echo '<span class="faq-icon" style="color: ' . esc_attr($icon_color) . ';">+</span>';  // Replace with desired icon (like + for accordion/toggle)
                }
                echo esc_html($question) . '</div>';

                // Answer (hidden by default for accordion-style)
                echo '<div class="faq-answer" style="display: none;">';
                echo esc_html($answer);
                echo '</div>';

                echo '</div>';
            }

            echo '</div>';
        }
    }

endif;

