<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_ContactInfo')):

/**
 * Elementor Contact Info Box Widget.
 *
 * @class BLOGINAC_Elementor_ContactInfo
 * @version 1.0.0
 */
class BLOGINAC_Elementor_ContactInfo extends BLOGINAC_Elementor_Base
{
    public function get_name()
    {
        return 'bloginac-contact-info-box';
    }

    public function get_title()
    {
        return __('Contact Info Box', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-address-card';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Phone Info
        $this->add_control(
            'phone_icon',
            [
                'label' => __('Phone Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'phone_number',
            [
                'label' => __('Phone Number', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('021-5463768', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Email Info
        $this->add_control(
            'email_icon',
            [
                'label' => __('Email Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-envelope',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'email_address',
            [
                'label' => __('Email Address', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('info@gmail.com', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Address Info
        $this->add_control(
            'address_icon',
            [
                'label' => __('Address Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-map-marker-alt',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'address',
            [
                'label' => __('Address', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Tehran', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <div class="py-10 lg:px-[118px] px-10 rounded-[var(--blg-radius-xl)] bg-[var(--blg-color-primary500)]">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 items-center justify-center">
                <!-- Phone Box -->
                <div class="flex items-center md:justify-center bg-[#2C3A4A] rounded-[var(--blg-radius-xl)] py-4 px-2 gap-x-3 min-h-20">
                    <div class="text-white mr-1">
                        <?php \Elementor\Icons_Manager::render_icon($settings['phone_icon'], ['aria-hidden' => 'true', 'class' => 'lg:w-6 lg:h-6 w-4 h-4 text-white']); ?>
                    </div>
                    <div class="bg-[var(--blg-color-primary200)] w-[1px] h-[30px]"></div> 
                    <div class="lg:text-[15px] text-sm font-medium text-[#E4E4E4]">
                        <span class="text-[var(--blg-color-primary200)] font-bold"><?php echo esc_html__('تلفن:', BLOGINAC_TEXT_DOMAIN); ?></span>
                        <?php echo esc_html($settings['phone_number']); ?>
                    </div>
                </div>
                
                <!-- Email Box -->
                <div class="flex items-center md:justify-center bg-[#2C3A4A] rounded-[var(--blg-radius-xl)] py-4 px-2 gap-x-3 min-h-20">
                    <div class="text-white mr-1">
                        <?php \Elementor\Icons_Manager::render_icon($settings['email_icon'], ['aria-hidden' => 'true', 'class' => 'lg:w-6 lg:h-6 w-4 h-4 text-white']); ?>
                    </div>
                    <div class="bg-[var(--blg-color-primary200)] w-[1px] h-[30px]"></div> 
                    <div class="lg:text-[15px] text-sm font-medium text-[#E4E4E4]">
                        <span class="text-[var(--blg-color-primary200)] font-bold"><?php echo esc_html__('ایمیل:', BLOGINAC_TEXT_DOMAIN); ?></span>
                        <?php echo esc_html($settings['email_address']); ?>
                    </div>
                </div>
                
                <!-- Address Box -->
                <div class="flex items-center md:justify-center bg-[#2C3A4A] rounded-[var(--blg-radius-xl)] py-4 px-2 gap-x-3 min-h-20">
                    <div class="text-white mr-1">
                        <?php \Elementor\Icons_Manager::render_icon($settings['address_icon'], ['aria-hidden' => 'true', 'class' => 'lg:w-6 lg:h-6 w-4 h-4 text-white']); ?>
                    </div>
                    <div class="bg-[var(--blg-color-primary200)] w-[1px] h-[30px]"></div> 
                    <div class="lg:text-[15px] text-sm font-medium text-[#E4E4E4]">
                        <span class="text-[var(--blg-color-primary200)] font-bold"><?php echo esc_html__('مکان:', BLOGINAC_TEXT_DOMAIN); ?></span>
                        <?php echo esc_html($settings['address']); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

endif;
