<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Category')):

/**
 * Elementor Category Widget.
 *
 * @class BLOGINAC_Elementor_Category
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Category extends BLOGINAC_Elementor_Base
{
    public $enable_slider;
    public $enable_autoplay;
    public $autoplay_delay;
    public $enable_loop;
    public $show_pagination;
    public $show_navigation;

    public $style_option;
    public $columns;
    public $columns_lg;
    public $columns_tablet;
    public $category_list;

    public function get_name()
    {
        return 'bloginac-category';
    }

    public function get_title()
    {
        return __('Blogina Category', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-archive';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        (new BLOGINAC_Controls_Category_Settings())->register_controls();
        (new BLOGINAC_Controls_Category_Title())->register_controls();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->category_list = $settings['categories_list'];
        $this->style_option = $settings['style_option'] ?? 'style1';
        $this->enable_slider = $settings['enable_sliders'] === 'yes';
        $this->enable_autoplay = $settings['enable_autoplay'] === 'yes';
        $this->autoplay_delay = $settings['autoplay_delay'] ?? 0;
        $this->enable_loop = $settings['enable_loop'] === 'yes' ? 'true' : 'false';
        $this->show_pagination = $settings['show_pagination'] === 'yes';
        $this->columns = $settings['columns_desktop'] ?? 6;
        $this->columns_lg = $settings['columns_lg'] ?? 3;
        $this->columns_tablet = $settings['columns_tablet'] ?? 2;

        if ($this->style_option == 'style2') return $this->include_elementor_html_file('category/style2.php');
        else return $this->include_elementor_html_file('category/style1.php');
    }
}

endif;
