<?php
// Prevent direct access
defined('ABSPATH') || die();

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_UpdatedBlog_Cards extends BLOGINAC_Elementor_UpdatedBlogs
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_blog_card_styles',
            [
                'label' => __('Updated Blog Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Start Tabs for Organization
        $this->start_controls_tabs('blog_card_style_tabs');

        // Start Card Styling Tab
        $this->start_controls_tab(
            'card_styling_tab',
            [
                'label' => __('General Styling', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Card Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-post-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        
        $this->add_control(
            'card_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-post-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_description_text_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-description' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .updatedblog-post-card',
            ]
        );

        $this->add_control(
            'card_padding',
            [
                'label' => __('Card Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'card_radius',
            [
                'label' => __('Card Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'size' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-post-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab(); // End Card Styling Tab

        // Start Text Styling Tab
        $this->start_controls_tab(
            'text_styling_tab',
            [
                'label' => __('Extra Styling', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'card_tag_bg_color',
            [
                'label' => __('Tag Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-tag' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_tag_text_color',
            [
                'label' => __('Tag Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-tag' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_title_icon_color',
            [
                'label' => __('Date Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-post-card svg circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_date_text_color',
            [
                'label' => __('Date Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updated-blog-post-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab(); // End Text Styling Tab

        // End Tabs
        $this->end_controls_tabs();

        // End Section
        $this->end_controls_section();
    }
}
