<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_SpeacialOffers_Cards extends BLOGINAC_Elementor_SpeacialOffers
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_course_card_styles',
            [
                'label' => __('Card Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Card Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .course-post-card .blg-ratings' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .course-post-card .countdown-wrapper' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        

        $this->add_control(
            'card_title_icon_color',
            [
                'label' => __('Title Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card svg circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // Card Padding Control
        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __('Card Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 4,
                    'right' => 4,
                    'bottom' => 4,
                    'left' => 4,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'card_radius',
            [
                'label' => __('Card Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 16,
                    'right' => 16,
                    'bottom' => 16,
                    'left' => 16,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .course-post-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-card',
            ]
        );

        // End Section
        $this->end_controls_section();

        $this->start_controls_section(
            'section_course_card_countdown_styles',
            [
                'label' => __('Countdown Timer', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'countdown_typography',
                'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-card .countdown-timer .countdown-number',
            ]
        );

        $this->add_control(
            'countdown_bg_color',
            [
                'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card .countdown-timer ' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'countdown_number_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card .countdown-timer .countdown-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'countdown_title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .course-post-card .countdown-timer .countdown-label',
            ]
        );

        $this->add_control(
            'countdown_title_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .course-post-card .countdown-timer .countdown-label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_box_styles',
            [
                'label' => __('Box Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ],

        );
            $this->add_control(
                'box_bg_color',
                [
                    'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .blg-course-style3' => 'background-color: {{VALUE}} !important;',
                        '{{WRAPPER}} .course-post-card:before' => ' box-shadow: -6px 5px 0 5px {{VALUE}};',
                        '{{WRAPPER}} .course-post-card:after' => ' box-shadow: -6px 5px 0 5px {{VALUE}};',
                        '{{WRAPPER}} .course-post-card .get_more' => 'background-color: {{VALUE}} !important;',
                        '{{WRAPPER}} .course-post-card .get_more >div.blg_add_to_cart_style3' => 'background-color: {{VALUE}} !important;',
                    ],
                ]
            );
        $this->end_controls_section();
    }
}
