<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Experts_Settings extends BLOGINAC_Elementor_Experts
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Start Section
        $this->start_controls_section(
            'bloginac_content_section',
            [
                'label' => __('Experts', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('Main Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our Expert', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('In the notebook, you can participate in courses and learn new things at the lowest cost without leaving your home or workplace.', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        // $this->add_control(
        //     'activate_random_order',
        //     [
        //         'label' => __('Activate Random Order', BLOGINAC_TEXT_DOMAIN),
        //         'type' => \Elementor\Controls_Manager::SWITCHER,
        //         'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
        //         'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
        //         'default' => 'yes',
        //     ]
        // );

        $this->end_controls_section();

        $this->start_controls_section(
            'bloginac_items_section',
            [
                'label' => __('Items', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'name',
            [
                'label' => __('Name', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Saman azizi', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'role',
            [
                'label' => __('Role', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Journalist', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Profile Image', BLOGINAC_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
            'slides',
            [
                'label' => __('Experts', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => __('Saman Azizi', BLOGINAC_TEXT_DOMAIN),
                        'image' => ['image' => '#'],
                        'role' => __('Programmer', BLOGINAC_TEXT_DOMAIN)
                    ],
                    [
                        'name' => __('Ali Rasouli', BLOGINAC_TEXT_DOMAIN),
                        'image' => ['image' => '#'],
                        'role' => __('designer', BLOGINAC_TEXT_DOMAIN)
                    ],
                ],
                'separator' => 'after',
                'title_field' => '{{{ name }}}',
            ]
        );


        // End Section
        $this->end_controls_section();
    }
}
