<?php if (!defined('ABSPATH')) exit; ?>

<div class="blog-sidebar-widget bg-white blg-shadow-sm p-5 flex flex-col gap-y-4 rounded-[20px] transition-all">
    <div class="flex justify-between items-center">
        <div class="flex flex-col gap-y-2">
            <h4 class="lg:text-xl font-[Pinar] text-lg font-bold text-[var(--blg-color-primary500)]">
                <?php echo apply_filters('widget_title', $title); ?>
            </h4>
            <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
            </div>
        </div>
    </div>
    <?php if (!empty($headings)) : ?>
        <ul class="post-headings-list flex flex-col gap-y-4 list-disc">
            <?php foreach ($headings as $heading) : ?>
                <li class="flex items-baseline gap-x-2 border-b border-gray-100 last:border-0 py-3 text-[15px] text-[var(--blg-gray)]">
                    <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                        <ellipse cx="4.35371" cy="4.5" rx="4.33613" ry="4.5" fill="var(--blg-color-secondary200)" />
                    </svg>
                    <a href="#<?php echo esc_attr($heading['id']); ?>" class="text-[var(--blg-color-primary500)] hover:text-[var(--blg-color-secondary200)]">
                        <?php echo esc_html($heading['text']); ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php else : ?>
        <p><?php esc_html_e('No headings found in this post.', BLOGINAC_TEXT_DOMAIN); ?></p>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    const postContent = $('.entry-content'); 
    if (postContent.length) {
        let headingCount = 0; 
        const headings = postContent.find('h1, h2, h3, h4, h5, h6');

        headings.each(function() {
            const heading = $(this);
            if (!heading.attr('id')) {
                heading.attr('id', `heading-${headingCount}`);
                headingCount++; 
            }
        });
    }

    $('.post-headings-list a').on('click', function(event) {
        event.preventDefault();
        const targetId = $(this).attr('href').substring(1);
        const targetElement = $(`#${targetId}`); 

        if (targetElement.length) {
            const offset = 40;
            $('html, body').animate({
                scrollTop: targetElement.offset().top - offset 
            }, 600);
        }
    });
});
</script>

