<?php
// no direct access
defined('ABSPATH') || die();
/** @var BLOGINAC_PTypes_Course $this */

// Define the tabs dynamically with icons
$tabs = apply_filters('blg_television_admin_tabs', [
    'gallery'   => [
        'label' => esc_html__('Gallery', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-images'
    ],
    'video'  => [
        'label' => esc_html__('Video', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-video'
    ],
]);


?>
<div class="blg-nav-tab-wrapper">
    <?php foreach ($tabs as $key => $tab): ?>
        <a href="#tab-<?php echo esc_attr($key); ?>" class="blg-nav-tab <?php echo $key === 'gallery' ? 'blg-nav-tab-active' : ''; ?>" data-tab="<?php echo esc_attr($key); ?>">
            <i class="<?php echo esc_attr($tab['icon']); ?>"></i>  <!-- Font Awesome icon -->
            <?php echo esc_html($tab['label']); ?>
        </a>
    <?php endforeach; ?>
</div>

