<?php
// no direct access
defined('ABSPATH') || die();

$categories = BLOGINAC_Entity_Television::get_primary_categories($post->ID); // Adjust to handle multiple terms
$selected_categories = $categories ? array_map('intval', wp_list_pluck($categories, 'term_id')) : []; // Get term IDs as an array.

// Output nonce for form security
BLOGINAC_Form::nonce('bloginac_television_cpt', '_blgnonce');
?>

<p><?php esc_html_e('Please select categories.', BLOGINAC_TEXT_DOMAIN); ?></p>

<div id="taxonomy-<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>" class="categorydiv">

    <ul id="<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>-tabs" class="category-tabs">
        <li class="tabs">
            <a href="#<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>-all">
                <?php esc_html_e('All Categories', BLOGINAC_TEXT_DOMAIN); ?>
            </a>
        </li>
        <li class="hide-if-no-js">
            <a href="#<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>-pop">
                <?php esc_html_e('Most Used', BLOGINAC_TEXT_DOMAIN); ?>
            </a>
        </li>
    </ul>

    <div id="<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>-all" class="tabs-panel">
        <ul>
            <?php
            wp_terms_checklist($post->ID, [
                'taxonomy' => BLOGINAC_Base::TAX_TELEVISION_CATEGORY,
                'selected_cats' => $selected_categories,
                'checked_ontop' => false,
            ]);
            ?>
        </ul>
    </div>

    <div id="<?php echo esc_attr(BLOGINAC_Base::TAX_TELEVISION_CATEGORY); ?>-pop" class="tabs-panel" style="display: none;">
        <?php
        // Get most used categories
        $popular_terms = get_terms([
            'taxonomy' => BLOGINAC_Base::TAX_TELEVISION_CATEGORY,
            'orderby' => 'count',
            'order' => 'DESC',
            'hide_empty' => false,
            'number' => 1, // Limit to the most used
            'fields' => 'ids',
        ]);

        // Get all categories to compare
        $all_terms = get_terms([
            'taxonomy' => BLOGINAC_Base::TAX_TELEVISION_CATEGORY,
            'fields' => 'ids',
            'hide_empty' => false,
        ]);

        // Exclude popular terms already shown in the "All Categories"
        $unique_popular_terms = array_diff($popular_terms, $all_terms);

        // Check and display popular categories
        if (!empty($unique_popular_terms)) :
            wp_terms_checklist($post->ID, [
                'taxonomy' => BLOGINAC_Base::TAX_TELEVISION_CATEGORY,
                'popular_cats' => $unique_popular_terms,
                'checked_ontop' => false,
            ]);
        else : ?>
            <p><?php esc_html_e('No popular categories available.', BLOGINAC_TEXT_DOMAIN); ?></p>
        <?php endif; ?>
    </div> <!-- End of most used categories panel -->

</div> <!-- End of categorydiv -->