<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;

$blg = get_post_meta($post->ID, 'blg-course', true);
$blg = is_array($blg) ? $blg : [];

$course = $blg['required-course'] ?? '';
$course_status = $blg['course-status'] ?? '';
$course_support_type = $blg['support-type'] ?? '';
$course_start_time = $blg['start-time'] ?? '';
$course_end_time = $blg['end-time'] ?? '';
$course_duration = $blg['duration'] ?? '';
$course_chapter_count = $blg['chapter_count'] ?? '';
$course_session_count = $blg['session_count'] ?? '';
$view_type = $blg['view-type'] ?? '';

$assets = new BLOGINAC_Assets();
$assets->footer('<script>
jQuery(document).ready(function() {
    jQuery(".blg-form-row").bloginaSyncCounts({
        ajax_url: "' . admin_url('admin-ajax.php') . '",
        nonce: "' . wp_create_nonce('sync_counts_nonce') . '",
        product_id: "'. $post->ID. '", 
    });
});
</script>');
?>

<div class="blg-metabox blg-course-module-price">

    <div class="blg-metabox-input">
        <div class="blg-form-row">
            <label for="blg_courses" class="blg-price-label blg-col-12"><?php echo esc_html__('Required course', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::courses([
                'name' => 'blg[required-course]',
                'id' => 'blg_courses',
                'value' => $course,
                'show_empty' => true,
                'empty_label' => esc_html__('Select required course', BLOGINAC_TEXT_DOMAIN)
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_courses_status" class="blg-status-label blg-col-12"><?php echo esc_html__('Course Status', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::select([
                'name' => 'blg[course-status]',
                'id' => 'blg_courses_status',
                'value' => $course_status,
                'options' => [
                    "complete" => esc_html__('complete', BLOGINAC_TEXT_DOMAIN),
                    'ongoing' => esc_html__('ongoing', BLOGINAC_TEXT_DOMAIN),
                    'canceled' => esc_html__('canceled', BLOGINAC_TEXT_DOMAIN),
                ],
                'show_empty' => true,
                'empty_label' => esc_html__('Select course status', BLOGINAC_TEXT_DOMAIN)
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_support_type" class="blg-support-type-label blg-col-12"><?php esc_html_e('Support Type', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::select([
                'name' => 'blg[support-type]',
                'id' => 'blg_support_type',
                'value' => $course_support_type,
                'options' => [
                    "online" => esc_html__('online', BLOGINAC_TEXT_DOMAIN),
                    'offline' => esc_html__('offline', BLOGINAC_TEXT_DOMAIN),
                ],
                'show_empty' => true,
                'empty_label' => esc_html__('Select Support Type', BLOGINAC_TEXT_DOMAIN)
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_view_type" class="blg-view-type-label blg-col-12"><?php esc_html_e('View Type', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::select([
                'name' => 'blg[view-type]',
                'id' => 'blg_view_type',
                'value' => $view_type,
                'options' => [
                    'video-download' => esc_html__('video-download', BLOGINAC_TEXT_DOMAIN),
                    'video' => esc_html__('video', BLOGINAC_TEXT_DOMAIN),
                    'download' => esc_html__('download', BLOGINAC_TEXT_DOMAIN),
                ],
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_start_time" class="blg-start-time-label blg-col-12">
                <?php esc_html_e('Start Time', BLOGINAC_TEXT_DOMAIN); ?>
            </label>
            <?php
            echo BLOGINAC_Form::text([
                'name' => 'blg[start-time]',
                'id' => 'blg_start_time',
                'value' => $course_start_time,
                'class' => 'persian-datepicker',
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_end_time" class="blg-end-time-label blg-col-12">
                <?php esc_html_e('End Time', BLOGINAC_TEXT_DOMAIN); ?>
            </label>
            <?php
            echo BLOGINAC_Form::text([
                'name' => 'blg[end-time]',
                'id' => 'blg_end_time',
                'value' => $course_end_time,
                'class' => 'persian-datepicker',
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_duration" class="blg-duration-label blg-col-12"><?php esc_html_e('Duration', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::text([
                'name' => 'blg[duration]',
                'id' => 'blg_duration',
                'value' => $course_duration,
            ]);
            ?>
        </div>

        <div class="blg-form-row">
            <label for="blg_chapter_count" class="blg-chapter-count-label blg-col-12"><?php esc_html_e('Chapter Count', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::text([
                'name' => 'blg[chapter_count]',
                'id' => 'blg_chapter_count',
                'value' => $course_chapter_count,
            ]);
            ?>
            <button class="blg-button-simple blg-color-main blg-button-sync blg-mx-1"><i class="fa fa-sync"></i></button>
        </div>

        <div class="blg-form-row">
            <label for="blg_session_count" class="blg-session-count-label blg-col-12"><?php esc_html_e('Session Count', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::text([
                'name' => 'blg[session_count]',
                'id' => 'blg_session_count',
                'value' => $course_session_count,
            ]);
            ?>
            <button class="blg-button-simple blg-color-main blg-button-sync blg-mx-1"><i class="fa fa-sync"></i></button>
        </div>

    </div>
</div>
