<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;

$blg = get_post_meta($post->ID, 'blg-course', true);
$blg = is_array($blg) ? $blg : [];

$course_view_type = $blg['course-view-type'] ?? '';

?>
<div class="blg-metabox blg-course-module-price">

    <div class="blg-metabox-input">
        <div class="blg-form-row">
            <label for="blg_courses_view_type" class="blg-view-type-label blg-col-12"><?php echo esc_html__('Course View Type', BLOGINAC_TEXT_DOMAIN); ?></label>
            <?php
            echo BLOGINAC_Form::select([
                'name' => 'blg[course-view-type]',
                'id' => 'blg_courses_view_type',
                'value' => $course_view_type,
                'options' => [
                    'videomode' => esc_html__('Video Modal', BLOGINAC_TEXT_DOMAIN),
                    'chaptermode' => esc_html__('Modal with chapter and session', BLOGINAC_TEXT_DOMAIN),
                    'sessionmode' => esc_html__('Below Session Name', BLOGINAC_TEXT_DOMAIN),
                    'slidermode' => esc_html__('Single Image Section', BLOGINAC_TEXT_DOMAIN),
                ],
                'show_empty' => true,
                'empty_label' => esc_html__('Select course view type', BLOGINAC_TEXT_DOMAIN)
            ]);
            ?>
        </div>
    </div>
    <label class="blg-d-block blg-my-5 blg-col-12"><?php echo esc_html__('Single Elements Visibility', BLOGINAC_TEXT_DOMAIN); ?></label>
    <div class="blg-form-row-switch blg-grid blg-grid-cols-2 blg-my-4">
        <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                'title' => esc_html__('Show as Slider', BLOGINAC_TEXT_DOMAIN),
                'for' => 'blg_show_single_details_as_slider',
            ]); ?></div>
        <div class="blg-col-4">
            <?php echo BLOGINAC_Form::switcher([
                'id' => 'blg_show_single_details_as_slider',
                'name' => 'blg[single][show_as_slider]',
                'value' => $blg['single']['show_as_slider'] ?? 0,
            ]); ?>
        </div>
    </div>
    <div class="blg-grid blg-grid-cols-3 blg-grid-cols-lg-2 blg-grid-cols-sm-1 blg-gap-3">
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Pre Course', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_show_single_pre_course',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_show_single_pre_course',
                    'name' => 'blg[single][show_pre_course]',
                    'value' => $blg['single']['show_pre_course'] ?? 1,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Course Status', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_course_status',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_course_status',
                    'name' => 'blg[single][show_course_status]',
                    'value' => $blg['single']['show_course_status'] ?? 1,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Last Update', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_last_update',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_last_update',
                    'name' => 'blg[single][show_last_update]',
                    'value' => $blg['single']['show_last_update'] ?? 1,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show View Type', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_view_type',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_view_type',
                    'name' => 'blg[single][show_view_type]',
                    'value' => $blg['single']['show_view_type'] ?? 1,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Learn', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_learn',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_learn',
                    'name' => 'blg[single][show_learn]',
                    'value' => $blg['single']['show_learn'] ?? 1,
                ]); ?>
            </div>
        </div>

        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Support Type', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_support_type',
                ]); ?></div>
            <div class="blg-col-4">
            <?php echo BLOGINAC_Form::switcher([
                'id' => 'blg_single_show_support_type',
                'name' => 'blg[single][show_support_type]',
                'value' => $blg['single']['show_support_type'] ?? 1,
            ]); ?>
        </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Start Date', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_start_date',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_start_date',
                    'name' => 'blg[single][show_start_date]',
                    'value' => $blg['single']['show_start_date'] ?? 0,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show End Date', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_end_date',
                ]); ?></div>
            <div class="blg-col-4">
                <?php echo BLOGINAC_Form::switcher([
                    'id' => 'blg_single_show_end_date',
                    'name' => 'blg[single][show_end_date]',
                    'value' => $blg['single']['show_end_date'] ?? 0,
                ]); ?>
            </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Course Duration', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_course_duration',
                ]); ?></div>
            <div class="blg-col-4">
            <?php echo BLOGINAC_Form::switcher([
                'id' => 'blg_single_show_course_duration',
                'name' => 'blg[single][show_course_duration]',
                'value' => $blg['single']['show_course_duration'] ?? 0,
            ]); ?>
        </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Chapter Counts', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_chapter_counts',
                ]); ?></div>
            <div class="blg-col-4">
            <?php echo BLOGINAC_Form::switcher([
                'id' => 'blg_single_show_chapter_counts',
                'name' => 'blg[single][show_chapter_counts]',
                'value' => $blg['single']['show_chapter_counts'] ?? 0,
            ]); ?>
        </div>
        </div>
        <div class="blg-form-row-switch">
            <div class="blg-col-2"><?php echo BLOGINAC_Form::label([
                    'title' => esc_html__('Show Session Counts', BLOGINAC_TEXT_DOMAIN),
                    'for' => 'blg_single_show_session_counts',
                ]); ?></div>
            <div class="blg-col-4">
            <?php echo BLOGINAC_Form::switcher([
                'id' => 'blg_single_show_session_counts',
                'name' => 'blg[single][show_session_counts]',
                'value' => $blg['single']['show_session_counts'] ?? 0,
            ]); ?>
        </div>
        </div>
    </div>
</div>
