<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_UpdatedBlogs $this */
$args = [
    'post_type'      => 'post',
    'posts_per_page' => 1,
    'orderby'        => 'rand',
];

$query = new WP_Query($args);

?>
<div class="blg-widget-padding-y">
    <div class="grid xl:grid-cols-12 grid-cols-1 gap-y-6 gap-x-6 blg-widget-padding-y">
        <div class="blg-shadow-sm updatedblog-post-card xl:col-span-8 col-span-1 flex lg:flex-row flex-col lg:gap-x-6 gap-x-0 lg:gap-y-0 gap-y-6 rounded-3xl bg-white py-6 px-6">
            <div class="flex flex-col gap-y-3 lg:w-[60%]">
                <?php
                if ($query->have_posts()) :
                    $query->the_post(); ?>
                
                    <?php if (has_post_thumbnail()) : ?>
                        <img width="100%" height="100%" class="!rounded-[20px] w-full !max-h-[290px] !h-[290px] !min-h-[290px] !object-cover" src="<?php the_post_thumbnail_url('large'); ?>" alt="<?php the_title(); ?>">
                    <?php else : ?>
                        <img width="100%" height="100%" class="!rounded-[20px] w-full !max-h-[290px] !h-[290px] !min-h-[290px] !object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title(); ?>">
                    <?php endif; ?>

                    <?php $categories = get_the_category(); ?>
                    <?php if (!empty($categories)) : ?>
                        <a class="bg-[var(--blg-color-primary400)] updatedblog-tag text-[var(--blg-color-primary500)] rounded text-xs font-normal text-nowrap max-w-max px-4 text-center py-[10px]" href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>">
                            <?php echo esc_html($categories[0]->name); ?>
                        </a>
                    <?php endif; ?>

                    <div class="flex flex-col gap-y-1 ">
                        <div class="flex gap-x-1 items-center">
                            <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                            </svg>
                            <h4 class="md:text-base !text-[14px] font-bold text-[var(--blg-color-primary500)]">
                                <a href="<?php the_permalink(); ?>" class="">
                                    <?php the_title(); ?>
                                </a>
                            </h4>
                        </div>

                        <p class="overflow-hidden text-right md:!text-[14px] text-sm text-[#727272] font-normal blg-description">
                            <?php echo wp_trim_words(get_the_excerpt(), 30, '...'); ?>
                        </p>
                    </div>

                <?php
                    wp_reset_postdata();
                else : ?>
                    <p><?php esc_html_e('No posts found', BLOGINAC_TEXT_DOMAIN); ?></p>
                <?php endif; ?>
            </div>
            <div class="md:!w-[1px] w-full md:!h-full h-[1px] !bg-[var(--blg-color-primary500)] opacity-15"></div>
            <div class="flex flex-col gap-y-6 lg:w-[40%]">
                <?php
                $query = new WP_Query($this->main_post_args);

                if ($query->have_posts()) :
                    while ($query->have_posts()) : $query->the_post(); ?>
                        <div class="flex gap-x-3 items-center">
                            <?php if (has_post_thumbnail()) : ?>
                                <img width="91" height="71" class="!rounded-lg w-full h-full !min-w-[91px] !min-h-[71px] !max-w-[91px] !max-h-[71px] object-cover" src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="<?php the_title(); ?>">
                            <?php else : ?>
                                <img width="91" height="71" class="!rounded-lg w-full h-full !min-w-[91px] !min-h-[71px] !max-w-[91px] !max-h-[71px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title(); ?>">
                            <?php endif; ?>

                            <div class="flex flex-col gap-y-3">
                                <div class="flex gap-x-1 items-center">
                                    <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="7" height="7" viewBox="0 0 7 7" fill="none">
                                        <circle cx="3.51367" cy="3.64209" r="3" fill="#727272" />
                                    </svg>
                                    <span class="text-xs text-[#727272] font-normal updated-blog-post-date">
                                        <?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' ' . esc_html__('ago', BLOGINAC_TEXT_DOMAIN); ?>
                                    </span>
                                </div>
                                <h4 class="md:text-base !text-[14px] font-bold text-[var(--blg-color-primary500)]">
                                    <a class="lg:flex hidden" href="<?php the_permalink(); ?>">
                                        <?php if (!empty(get_the_title())) echo mb_strimwidth(get_the_title(), 0, 25, '...'); ?>
                                    </a>
                                    <a class="lg:hidden flex" href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h4>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata();
                else : ?>
                    <p><?php esc_html_e('No posts found', BLOGINAC_TEXT_DOMAIN); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <div class="xl:col-span-4 col-span-1 gap-y-4 flex flex-col">
            <div class="blg-shadow-sm updatedblog-latest-post-card flex flex-col gap-y-5 rounded-3xl bg-white py-6 px-6">
                <div class="w-full">
                    <div class="flex justify-between items-center">
                        <div class="flex flex-col gap-y-2">
                            <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo $this->latest_posts_title; ?></h3>
                            <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                                <div class="h-[3px] !rounded-lg bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px] blg-title-underline"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex flex-col gap-y-6">
                    <?php
                    $query = new WP_Query($this->latest_posts_args);

                    if ($query->have_posts()) :
                        $total_posts = $query->post_count;
                        $post_index = 0;

                        while ($query->have_posts()) : $query->the_post();
                            $post_index++;
                    ?>
                            <div class="flex flex-col gap-y-3">
                                <div class="flex gap-x-1 items-center">
                                    <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="7" height="7" viewBox="0 0 7 7" fill="none">
                                        <circle cx="3.51367" cy="3.64209" r="3" fill="#727272" />
                                    </svg>
                                    <span class="text-xs text-[#727272] font-normal latest-post-date">
                                        <?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' ' . esc_html__('ago', BLOGINAC_TEXT_DOMAIN); ?>
                                    </span>
                                </div>

                                <h4 class="md:text-base !text-[14px] font-bold text-[var(--blg-color-primary500)]">
                                    <a class="lg:flex hidden" href="<?php the_permalink(); ?>">
                                        <?php if (!empty(get_the_title())) echo mb_strimwidth(get_the_title(), 0, 50, '...'); ?>
                                    </a>
                                    <a class="lg:hidden flex" href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h4>

                                <?php if ($post_index < $total_posts) : ?>
                                    <div class="h-[1px] w-full bg-[var(--blg-color-primary500)] opacity-15"></div>
                                <?php endif; ?>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                    else : ?>
                        <p><?php esc_html_e('No posts found', BLOGINAC_TEXT_DOMAIN); ?></p>
                    <?php endif; ?>

                </div>

            </div>
            <div class="blg-shadow-sm newsletter-card flex flex-col gap-y-5 rounded-3xl bg-[#DBE3EA] py-6 px-6">
                <div class="w-full">
                    <div class="flex justify-between items-center">
                        <div class="flex flex-col gap-y-2">
                            <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo $this->newsletter_title; ?></h3>
                            <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                                <div class="h-[3px] rounded-lg bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px] blg-title-underline"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex relative w-full">
                    <input type="email" name="email" autocomplete="true" placeholder="<?php echo esc_html__('Enter your Email', BLOGINAC_TEXT_DOMAIN); ?>" class="w-full !p-0 !bg-white rounded-lg outline-none h-12 !pl-10 !pr-2"> <!-- Adjusted padding for left space -->

                    <div class="absolute top-1/2 left-2 transform -translate-y-1/2 bg-[var(--blg-color-primary500)] rounded-[6px] p-[6px]">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                            <path d="M15.3658 10.0333V12.2583C15.3658 15.0167 13.4075 16.15 11.0158 14.7667L9.09082 13.65L7.16582 12.5333C4.77415 11.15 4.77415 8.89166 7.16582 7.50833L9.09082 6.39166L11.0158 5.27499C13.4075 3.91666 15.3658 5.04166 15.3658 7.80833V10.0333Z" fill="white" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
