<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Slide $this */

$slides = $this->slides;
$enable_loop = $this->loop ? 'true' : 'false';
$autoplay = $this->autoplay ? 'true' : 'false';
?>

<div class="blgelm-slides-wrapper blg-style-<?php echo esc_attr($this->style); ?>"
     data-style="<?php echo esc_attr($this->style); ?>"
     data-loop="<?php echo esc_attr($this->loop ? 'true' : 'false'); ?>"
     data-autoplay="<?php echo esc_attr($this->autoplay ? 'true' : 'false'); ?>"
     data-autoplay-delay="<?php echo esc_attr($this->autoplay_delay); ?>">
    <div class="blg-slide blg-slides">
        <div class="swiper-wrapper">
            <?php foreach ($slides as $slide): ?>
                <div class="swiper-slide" style="background: <?php echo esc_attr($slide['background_color']); ?>;">
                    <img src="<?php echo esc_url($slide['background_image']['url']); ?>" alt="">
                    <?php if ($this->style !== 'big-slider'): ?>
                        <div class="blg-card-content">
                            <h3 class="blg-card-title"><?php echo esc_html($slide['card_title'] ?? ''); ?></h3>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->style === 'big-slider'): ?>
                        <div class="blg-big-card-content">
                            <h3 class="blg-card-title"><?php echo esc_html($slide['card_title'] ?? ''); ?></h3>
                            <p class="blg-card-description"><?php echo esc_html($slide['card_description'] ?? ''); ?></p>
                            <?php if (!empty($slide['button_text']) && !empty($slide['button_url'])): ?>
                                <a href="<?php echo esc_url($slide['button_url']['url']); ?>" class="blg-card-button">
                                    <?php echo esc_html($slide['button_text']); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <!-- Special Elements for Big Slider -->
        <?php if ($this->style === 'big-slider'): ?>
            <div class="swiper-pagination blg-swiper-pagination"></div>
        <?php endif; ?>

        <?php if ($this->style === 'autoplay-progress'): ?>
            <div class="autoplay-progress">
                <svg viewBox="0 0 48 48">
                    <circle cx="24" cy="24" r="20"></circle>
                </svg>
                <span></span>
            </div>
        <?php endif; ?>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Select all slide wrappers on the page
        const slideWrappers = document.querySelectorAll(".blgelm-slides-wrapper");

        slideWrappers.forEach(function (wrapper, index) {
            const swiperContainer = wrapper.querySelector(".blg-slides");
            const style = wrapper.dataset.style;
            const loop = wrapper.dataset.loop === "true";
            const autoplay = wrapper.dataset.autoplay === "true"
                ? {delay: parseInt(wrapper.dataset.autoplayDelay, 10) || 3000}
                : false;
            // Define unique config for each slider
            let swiperConfig = {
                grabCursor: true,
                loop: loop,
                autoplay: autoplay,
            };

            // Apply style-specific configurations
            switch (style) {
                case 'big-slider':
                    swiperConfig = {
                        loop: loop,
                        autoplay: autoplay,
                        effect: "fade",
                        speed: 800,
                        pagination: {
                            el: wrapper.querySelector(".swiper-pagination"),
                            clickable: true,
                        },
                    };
                    break;

                case 'cards':
                    swiperConfig.effect = "cards";
                    break;

                case 'creative':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, translate: [0, 0, -400]},
                        next: {translate: ["100%", 0, 0]},
                    };
                    break;

                case 'creative-2':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, translate: ["-120%", 0, -500]},
                        next: {shadow: true, translate: ["120%", 0, -500]},
                    };
                    break;

                case 'creative-3':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, translate: ["-20%", 0, -1]},
                        next: {translate: ["100%", 0, 0]},
                    };
                    break;
                case 'creative-4':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, translate: [0, 0, -800], rotate: [180, 0, 0]},
                        next: {shadow: true, translate: [0, 0, -800], rotate: [-180, 0, 0]},
                    };
                    break;

                case 'creative-5':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, translate: ["-125%", 0, -800], rotate: [0, 0, -90]},
                        next: {shadow: true, translate: ["125%", 0, -800], rotate: [0, 0, 90],},
                    };
                    break;
                case 'creative-6':
                    swiperConfig.effect = "creative";
                    swiperConfig.creativeEffect = {
                        prev: {shadow: true, origin: "left center", translate: ["-5%", 0, -200], rotate: [0, 100, 0]},
                        next: {origin: "right center", translate: ["5%", 0, -200], rotate: [0, -100, 0]},
                    };
                    break;

                case 'autoplay-progress':
                    const progressCircle = wrapper.querySelector(".autoplay-progress svg");
                    const progressContent = wrapper.querySelector(".autoplay-progress span");

                    swiperConfig.spaceBetween = 30;
                    swiperConfig.centeredSlides = true;
                    swiperConfig.pagination = {
                        el: wrapper.querySelector(".swiper-pagination"),
                        clickable: true,
                    };
                    swiperConfig.navigation = {
                        nextEl: wrapper.querySelector(".swiper-button-next"),
                        prevEl: wrapper.querySelector(".swiper-button-prev"),
                    };
                    swiperConfig.on = {
                        autoplayTimeLeft(s, time, progress) {
                            if (progressCircle && progressContent) {
                                progressCircle.style.setProperty("--progress", 1 - progress);
                                progressContent.textContent = `${Math.ceil(time / 1000)}s`;
                            }
                        }
                    };
                    break;

                case 'coverflow':
                    swiperConfig.effect = "coverflow";
                    swiperConfig.centeredSlides = true;
                    swiperConfig.slidesPerView = "auto";
                    swiperConfig.coverflowEffect = {
                        rotate: 50,
                        stretch: 0,
                        depth: 100,
                        modifier: 1,
                        slideShadows: true,
                    };
                    swiperConfig.pagination = {
                        el: wrapper.querySelector(".swiper-pagination"),
                    };
                    break;

                case 'cube':
                    swiperConfig.effect = "cube";
                    swiperConfig.cubeEffect = {
                        shadow: true,
                        slideShadows: true,
                        shadowOffset: 20,
                        shadowScale: 0.94,
                    };
                    swiperConfig.pagination = {
                        el: wrapper.querySelector(".swiper-pagination"),
                    };
                    break;
            }

            // Initialize Swiper for this specific container
            new Swiper(swiperContainer, swiperConfig);
        });
    });
</script>


<style>
    <?php switch ($this->style):
    case 'big-slider':
        ?>
    .blg-style-big-slider {
        position: relative;
        width: 100%;
        height: 60vh;
        min-height: 480px;
        overflow: hidden;
    }
    .blg-style-big-slider .blg-slide {
        width: 100%;
        height: 60vh;
        min-height: 480px;
    }

    .blg-style-big-slider .swiper-pagination-bullet {
        background-color: white;
        border: 2px solid var(--blg-color-secondary200);
    }

    .blg-style-big-slider .swiper-pagination-bullet-active {
        background-color: var(--blg-color-secondary200);
    }

    .blg-style-big-slider .swiper-slide {
        position: relative;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        border-radius: 0;
    }

    .blg-style-big-slider .blg-big-card-content {
        position: absolute;
        bottom: 2%;
        right: 2%;
        max-width: 100%;
        text-align: center;
        color: #fff;
        background: rgb(148 148 148 / 40%);
        backdrop-filter: blur(20px);
        padding: 20px;
        border-radius: 10px;
        opacity: 1;
    }

    .blg-style-big-slider .blg-card-title {
        font-size: 2.5rem;
        margin-bottom: 10px;
    }

    .blg-style-big-slider .blg-card-description {
        font-size: 1.2rem;
        margin-bottom: 15px;
    }

    .blg-style-big-slider .blg-card-button {
        display: inline-block;
        background: #ff5722;
        color: #fff;
        padding: 12px 24px;
        font-size: 1rem;
        border-radius: 5px;
        text-decoration: none;
        transition: background 0.3s ease;
    }

    .blg-style-big-slider .blg-card-button:hover {
        background: #e64a19;
    }

    .blg-style-big-slider .swiper-pagination {
        bottom: 10px;
        text-align: center;
    }
        <?php break;
     case 'creative':
     case 'creative-2':
     case 'creative-3':
     case 'creative-4':
     case 'creative-5':
     case 'creative-6':
         ?>
    .blg-style-creative,
    .blg-style-creative-2,
    .blg-style-creative-3,
    .blg-style-creative-4,
    .blg-style-creative-5,
    .blg-style-creative-6 {
        overflow: hidden !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
    }

    .blg-style-creative .blg-slide,
    .blg-style-creative-2 .blg-slide,
    .blg-style-creative-3 .blg-slide,
    .blg-style-creative-4 .blg-slide,
    .blg-style-creative-5 .blg-slide,
    .blg-style-creative-6 .blg-slide, {
        margin: 100px auto !important;
        width: 320px !important;
        height: 240px !important;
    }

    .blg-style-creative .swiper-slide,
    .blg-style-creative-2 .swiper-slide,
    .blg-style-creative-3 .swiper-slide,
    .blg-style-creative-4 .swiper-slide,
    .blg-style-creative-5 .swiper-slide,
    .blg-style-creative-6 .swiper-slide, {
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        font-size: 22px !important;
        font-weight: bold !important;
        color: #fff !important;
    }

    <?php break;

case 'cards': ?>
    .blg-style-cards .blg-slide {
        width: 240px;
        height: 320px;
    }

    .blg-style-cards .swiper-slide {
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 18px;
        font-size: 22px;
        font-weight: bold;
        color: #fff;
    }

    <?php break;

case 'autoplay-progress': ?>
    .blg-style-autoplay-progress {
        overflow: hidden;
    }

    .blg-style-autoplay-progress .blg-slide {
        width: 100% !important;
        height: 100% !important;
    }

    .blg-style-autoplay-progress .swiper-slide {
        text-align: center;
        font-size: 18px;
        background: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    <?php break;

    case 'cube': ?>
    .blg-style-cube {
        overflow: hidden;
    }

    .blg-style-cube .blg-slide {
        width: 300px;
        height: 300px;
        position: absolute;
        left: 50%;
        top: 50%;
        margin-left: -150px;
        margin-top: -150px;
    }

    .blg-style-cube .swiper-slide img {
        display: block;
        width: 100%;
    }

    .blg-style-cube .swiper-slide {
        background-position: center;
        background-size: cover;
    }

    <?php break;
        case 'coverflow': ?>
    .blg-style-coverflow .blg-slide {
        width: 100%;
    }

    .blg-style-coverflow .swiper-slide img {
        display: block;
        width: 100%;
    }

    .blg-style-coverflow .swiper-slide {
        background-position: center;
        background-size: cover;
        width: 300px;
        height: 300px;
    }

    <?php break;
endswitch; ?>
</style>
