<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Course $this */

$product_archive_url = get_post_type_archive_link('product');
$display_regular_price = BLOGINA_Settings::get('blg_show_regular_price');
$display_sale_price = BLOGINA_Settings::get('blg_show_sale_price');
$posts_query = $this->post_query;
$unique_id = uniqid($this->style_option .'-');

?>

<div class="blg-widget-padding-y">
    <div class="w-full lg:my-0 my-4">
        <div class="flex justify-between items-center course-post-title">
            <div class="flex flex-col gap-y-2">
                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html($this->main_title); ?></h3>
                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                    <div class="h-[3px] blg-title-underline rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                </div>
            </div>
            <?php if ($this->show_buttons || $this->enable_slider) : ?>
                <div class="flex gap-x-2 items-center">
                    <?php if($this->enable_slider && $this->show_navigation): ?>
                        <div class="lg:flex hidden course-<?php echo esc_attr($unique_id); ?>-button-next">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                <path d="M31.5364 48H17.1364C5.13643 48 0.336426 43.2 0.336426 31.2V16.8C0.336426 4.8 5.13643 0 17.1364 0H31.5364C43.5364 0 48.3364 4.8 48.3364 16.8V31.2C48.3364 43.2 43.5364 48 31.5364 48Z" fill="var(--blg-color-primary500)" />
                                <path d="M21.3123 32.472L29.7603 24L21.3123 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                        <div class="lg:flex hidden course-<?php echo esc_attr($unique_id); ?>-button-prev">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                <path d="M17.1364 48H31.5364C43.5364 48 48.3364 43.2 48.3364 31.2V16.8C48.3364 4.8 43.5364 0 31.5364 0H17.1364C5.13643 0 0.336426 4.8 0.336426 16.8V31.2C0.336426 43.2 5.13643 48 17.1364 48Z" fill="var(--blg-color-primary500)" />
                                <path d="M27.3606 32.472L18.9126 24L27.3606 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->show_buttons) :?>
                        <div class="md:flex hidden">
                            <a href="<?php echo esc_url($product_archive_url); ?>" aria-label="view all" class="blg-btn-secondary">
                                <?php echo $this->button_text; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- Post Grid -->
    <div class="<?php echo $this->enable_slider ? $unique_id . 'swiper-container' : ''?> lg:flex hidden w-full md:h-auto h-full lg:!overflow-x-hidden lg:!overflow-y-hidden lg:px-[18px] xl:px-[30] lg:py-10 blg-course-<?php echo esc_attr($this->style_option); ?>">
        <div class="<?php echo $this->enable_slider ? 'swiper-wrapper' : 'grid gap-y-6 gap-x-6 grid-cols-'. $this->columns; ?>">
            <?php while ($posts_query->have_posts()): $posts_query->the_post(); ?>
                <div class="<?php echo $this->enable_slider ? 'swiper-slide' : ''; ?> blg-shadow-sm course-post-card flex flex-col gap-y-5 rounded-3xl bg-white md:p-6 p-4 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75">
                    <div class="flex flex-col gap-y-3">
                        <a href="<?php the_permalink(); ?>" class="w-full" aria-label="course style2">

                            <?php if (has_post_thumbnail()): ?>
                                <div class="blg_course_grid">
                                    <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                        <img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo the_post_thumbnail_url(); ?>" alt="">
                                    </div>
                                    <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
                                        <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
                                            <path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
                                            <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
                                        </svg>
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="blg_course_grid">
                                    <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                        <img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="">
                                    </div>
                                    <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
                                        <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
                                            <path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
                                            <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
                                        </svg>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </a>

                        <div class="w-full flex items-center justify-between">
                            <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>">
                                <div class="!flex !gap-x-1 !items-center">
                                    <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                        <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                    </svg>
                                    <h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                                </div>
                            </a>
                            <?php echo BLOGINA_Course::get_rating(); ?>
                        </div>
                    </div>

                    <div class="w-full flex md:flex-row flex-col items-center justify-between gap-x-2">

                        <div class="flex w-full gap-x-3">
                            <?php echo BLOGINA_Post::tags(2, BLOGINAC_Base::TAX_COURSE_TAG); ?>
                        </div>

                        <?php global $product; $price = BLOGINA_Course::get_price(true); ?>
                        <div class="flex gap-x-1 w-full items-center justify-end">
                            <?php if ($display_sale_price && $price['sale_price']): ?>
                                <div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px]">
                                    <del><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></del>
                                </div>
                                <?php if ($price['sale_price'] && $price['regular_price'] && $display_regular_price): ?>
                                    <div class="w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
                                <?php endif; ?>
                                <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['sale_price']); ?></div>
                            <?php elseif ($display_regular_price): ?>
                                <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></div>
                            <?php endif; ?>

                            <?php if ($display_regular_price || $display_sale_price): ?>
                                <div class="text-[#858585] text-[14px] font-['YekanBakh']"><?php echo BLOGINA_Course::get_currency(); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
        <?php if($this->enable_slider && $this->show_pagination) : ?>
            <div class="course-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
        <?php endif; ?>
    </div>

    <!-- Post Grid -->
    <div class="lg:hidden grid grid-cols-1 gap-y-6 w-full h-full lg:px-[18px] xl:px-[30] lg:py-10 blg-course-<?php echo esc_attr($this->style_option); ?>">
        <?php while ($posts_query->have_posts()): $posts_query->the_post(); ?>
            <div class="relative blg-shadow-sm course-post-card flex flex-col gap-y-5 rounded-3xl bg-white md:p-6 p-4 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75">
                <div class="flex flex-col gap-y-3">
                    <a href="<?php the_permalink(); ?>" class="w-full" aria-label="course style2">

                        <?php if (has_post_thumbnail()): ?>
                            <div class="blg_course_grid">
                                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                    <img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo the_post_thumbnail_url(); ?>" alt="">
                                </div>
                                <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
                                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
                                        <path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
                                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
                                    </svg>
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="blg_course_grid">
                                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                    <img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="">
                                </div>
                                <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
                                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
                                        <path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
                                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
                                    </svg>
                                </a>
                            </div>
                        <?php endif; ?>
                    </a>

                    <div class="w-full flex items-center justify-between">
                        <div class="!flex !gap-x-1 !items-center">
                            <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                            </svg>
                            <h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                        </div>
                        <?php echo BLOGINA_Course::get_rating(); ?>
                    </div>
                </div>

                <div class="w-full flex md:flex-row flex-col items-center justify-between gap-x-2">

                    <div class="flex w-full gap-x-3">
                        <?php echo BLOGINA_Post::tags(2, BLOGINAC_Base::TAX_COURSE_TAG); ?>
                    </div>

                    <div class="flex gap-x-1 w-full items-center justify-end">
                        <?php global $product; $price = BLOGINA_Course::get_price(true); ?>
                        <?php if ($display_sale_price && $price['sale_price']): ?>
                            <div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px]">
                                <del><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></del>
                            </div>
                            <?php if ($price['sale_price'] && $price['regular_price'] && $display_regular_price): ?>
                                <div class="w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
                            <?php endif; ?>
                            <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['sale_price']); ?></div>
                        <?php elseif ($display_regular_price): ?>
                            <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></div>
                        <?php endif; ?>

                        <?php if ($display_regular_price || $display_sale_price): ?>
                            <?php if(!BLOGINA_Course::is_product_free($product)): ?>
                                <div class="text-[#858585] text-[14px] font-['YekanBakh']"><?php echo BLOGINA_Course::get_currency(); ?></div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    </div>
</div>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            navigation: {
                nextEl: '.course-<?php echo esc_attr($unique_id); ?>-button-next',
                prevEl: '.course-<?php echo esc_attr($unique_id); ?>-button-prev',
            },
            pagination: {
                el: '.course-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 2,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
            },
            <?php endif; ?>
            breakpoints: {
                768 : { slidesPerView: <?php echo esc_attr($this->columns); ?> },
            },
        });
    </script>
<?php endif; ?>
