<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Category $this */

$unique_id = uniqid($this->style_option .'-');
?>
<div class="w-full blg-widget-padding-y flex items-center justify-center">
    <div class="<?php echo $this->enable_slider ? $unique_id . 'swiper-container overflow-hidden md:p-8 p-4' : 'grid xl:grid-cols-'. $this->columns .' 2xl:grid-cols-'. $this->columns .' lg:grid-cols-'. $this->columns_lg .' md:grid-cols-'. $this->columns_tablet .' grid-cols-2  gap-x-4 gap-y-4 md:gap-x-6 !items-center !justify-center' ?>" >
        <?php echo $this->enable_slider ? '<div class="swiper-wrapper">': ''; ?>

        <?php foreach ($this->category_list as $category): ?>
            <?php $target = $category['category_link']['is_external'] ? ' target="_blank"' : ''; $nofollow = $category['category_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
            <a href="<?php echo esc_url($category['category_link']['url']); ?>" <?php echo $target . $nofollow; ?>
               class="<?php echo $this->enable_slider ? 'swiper-slide': ''; ?> flex items-center justify-center blg-category-bg hover:bg-[var(--blg-color-secondary200)] hover:text-white transition-all duration-200 md:rounded-[var(--blg-radius-3xl)] rounded-[16px] blg-shadow-sm md:p-5 p-2 md:min-h-[110px] min-h-[73px] <?php echo !$this->enable_slider ? 'md:min-w-[196px] max-w-[162px]' : ''; ?>">
                <div class="flex items-center gap-x-5">
                    <div class="category-icon-wrapper">
                        <?php \Elementor\Icons_Manager::render_icon($category['category_icon'], ['aria-hidden' => 'true', 'class' => 'category-icon md:w-auto md:h-auto w-10 h-10']); ?>
                    </div>
                    <span class="md:text-lg text-[15px] font-medium category-name"><?php echo esc_html($category['category_name']); ?></span>
                </div>
            </a>
        <?php endforeach; ?>
        <?php echo $this->enable_slider ? '</div>' : '';?>
        <?php if($this->enable_slider && $this->show_pagination) : ?>
            <div class="category-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
        <?php endif; ?>
    </div>
</div>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            pagination: {
                el: '.category-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1024: { slidesPerView: <?php echo esc_attr($this->columns_lg); ?> },
                1025: {slidesPerView: <?php echo esc_attr($this->columns); ?>}
            },
        });
    </script>
<?php endif; ?>
