<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Posts $this */

$blog_archive_url = get_post_type_archive_link('post');


$query_args = [
    'post_type' => 'post',
    'posts_per_page' => $this->posts_count,
    'orderby' => $this->post_order,
    'cat' => $this->post_category,
];
$posts_query = new \WP_Query($query_args);
$unique_id = uniqid($this->style_option .'-');

?>
<div class="blg-widget-padding-y">
    <div class="w-full my-8">
        <div class="flex justify-between items-center blog-post-title">
            <div class="flex flex-col gap-y-2">
                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html($this->main_title); ?></h3>
                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                    <div class="h-[3px] rounded-[var(--blg-radius-lg)] blg-title-underline bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                </div>
            </div>
            <?php if ($this->show_buttons || $this->enable_slider) : ?>
                <div class="flex gap-x-2 items-center">
                    <?php if($this->enable_slider && $this->show_navigation): ?>
                        <div class="lg:flex hidden blog-<?php echo esc_attr($unique_id); ?>-button-next">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                <path d="M31.5364 48H17.1364C5.13643 48 0.336426 43.2 0.336426 31.2V16.8C0.336426 4.8 5.13643 0 17.1364 0H31.5364C43.5364 0 48.3364 4.8 48.3364 16.8V31.2C48.3364 43.2 43.5364 48 31.5364 48Z" fill="var(--blg-color-primary500)" />
                                <path d="M21.3123 32.472L29.7603 24L21.3123 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                        <div class="lg:flex hidden blog-<?php echo esc_attr($unique_id); ?>-button-prev">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                <path d="M17.1364 48H31.5364C43.5364 48 48.3364 43.2 48.3364 31.2V16.8C48.3364 4.8 43.5364 0 31.5364 0H17.1364C5.13643 0 0.336426 4.8 0.336426 16.8V31.2C0.336426 43.2 5.13643 48 17.1364 48Z" fill="var(--blg-color-primary500)" />
                                <path d="M27.3606 32.472L18.9126 24L27.3606 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>

                    <?php endif; ?>

                    <?php if ($this->show_buttons) : ?>
                        <div class="md:flex hidden gap-x-2 items-center">
                            <a href="<?php echo esc_url($blog_archive_url); ?>" aria-label="view all" class="blg-btn-secondary">
                                <?php echo $this->button_text; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($this->show_filters && !$this->enable_slider) : ?>
        <div class="flex gap-x-4 max-lg:overflow-scroll text-nowrap lg:py-0 py-2" id="categories-list">
            <button aria-label="filter" data-id="0" class="blg-filter-posts-button blg-active-category">
                <div class="blog-post-filter-title flex items-center justify-center gap-x-1 border border-solid border-[var(--blg-color-primary400)] rounded-[var(--blg-radius-lg)] md:py-2 py-1 md:px-4 px-2 text-nowrap">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <circle cx="4.54346" cy="4.31494" r="4" fill="var(--blg-color-primary500)"/>
                        </svg>
                    </span>
                    <span class="md:text-lg text-sm font-medium text-[var(--blg-color-primary500)]"><?php _e('All', BLOGINAC_TEXT_DOMAIN); ?></span>
                </div>
            </button>

            <?php
            $assets = new BLOGINAC_Assets();
            $assets->footer('<script>
            jQuery(document).ready(function() {
                jQuery("#categories-list").bloginaBlogWidgetFilter({
                    ajax_url: "' . admin_url('admin-ajax.php') . '",
                    nonce: "' . wp_create_nonce('lsd_filter_blogs_nonce') . '"
                });
            });
            </script>');

            $categories = get_categories();
            foreach ($categories as $category): ?>
                <button aria-label="filter category" data-id="<?php echo $category->term_id; ?>" class="blg-filter-posts-button">
                    <div class="blog-post-filter-title flex items-center justify-center gap-x-1 border border-solid border-[var(--blg-color-primary400)] rounded-[var(--blg-radius-lg)] md:py-2 py-1 md:px-4 px-2 text-nowrap">
                        <span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                                <circle cx="4.54346" cy="4.31494" r="4" fill="var(--blg-color-primary500)"/>
                            </svg>
                        </span>
                        <span class="md:text-lg text-sm font-medium text-[var(--blg-color-primary500)]"><?php echo esc_html($category->name); ?></span>
                    </div>
                </button>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div id="post-container" class="<?php echo $this->enable_slider ? $unique_id . 'swiper-container overflow-hidden p-8' : 'grid xl:grid-cols-'. $this->columns .' 2xl:grid-cols-'. $this->columns .' lg:grid-cols-'. $this->columns_lg .' md:grid-cols-'. $this->columns_tablet .' grid-cols-1 gap-y-6 gap-x-6'; ?> blg-widget-padding-y">
        <?php echo $this->enable_slider ? '<div class="swiper-wrapper">': ''; ?>

        <?php $post_count = 0;
        while ($posts_query->have_posts()): $posts_query->the_post(); $post_count++; $additional_class = $post_count > 4 ? ' hidden-mobile' : ''; ?>
                <div class="<?php echo $this->enable_slider ? 'swiper-slide': ''; ?> blg-shadow-sm blog-post-card flex flex-col gap-y-5 rounded-[var(--blg-radius-3xl)] bg-white md:p-6 p-4 max-h-[506px]<?php echo $additional_class; ?>">
                <div class="flex flex-col gap-y-3">
                    <a href="<?php the_permalink(); ?>" class="w-full" aria-label="blog style1">
                        <?php if (has_post_thumbnail()): ?>
                            <img width="100%" height="220"
                                 class="!rounded-[20px] w-full !max-h-[220px] !min-h-[220px] object-cover"
                                 src="<?php echo get_the_post_thumbnail_url(); ?>"
                                 alt="<?php the_title_attribute(); ?>">
                        <?php else: ?>
                            <img width="100%" height="220"
                                 class="!rounded-[20px] w-full !max-h-[220px] !min-h-[220px] object-cover"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp"
                                 alt="<?php the_title_attribute(); ?>">
                        <?php endif; ?>
                    </a>
                    <?php if ($this->show_tag) : ?>
                    <a class="bg-[var(--blg-color-primary400)] rounded text-xs font-normal px-4 text-center py-[10px] text-nowrap max-w-max"
                       href="<?php the_permalink(); ?>">
                        <?php
                        $categories = get_the_category();
                        echo !empty($categories) ? esc_html($categories[0]->name) : __('Uncategorized', BLOGINAC_TEXT_DOMAIN);
                        ?>
                    </a>
                    <?php endif; ?>
                    <a href="<?php the_permalink(); ?>">
                        <div class="!flex !gap-x-1 !items-center">
                            <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg"
                                 width="6" height="6" viewBox="0 0 6 6" fill="none">
                                <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)"/>
                            </svg>
                            <h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)] blg-title-truncate"><?php the_title(); ?></h4>
                        </div>
                    </a>
                    <p class="overflow-hidden text-right md:text-[15px] text-sm text-[#727272] font-normal blog-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 9, '...'); ?></p>
                </div>
                <div class="w-full flex items-center justify-between">
                    <?php if ($this->show_author) : ?>
                        <div class="flex gap-x-1 items-center">
                            <div class="bg-gray-300 rounded-full w-9 h-9">
                                <?php
                                echo BLOGINA_User::get_avatar(get_the_ID(), 36, '!rounded-full');
                                ?>
                            </div>
                            <span class="md:text-[14px] text-xs font-medium text-[var(--blg-color-primary500)]"><?php the_author(); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->show_time) : ?>
                        <div class="flex items-center gap-x-[2px]">
                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                                 fill="none">
                                <path d="M10.2698 18.4154C14.2537 18.4154 17.4834 15.1806 17.4834 11.1904C17.4834 7.20014 14.2537 3.96539 10.2698 3.96539C6.2858 3.96539 3.05615 7.20014 3.05615 11.1904C3.05615 15.1806 6.2858 18.4154 10.2698 18.4154Z"
                                      fill="var(--blg-color-primary400)"/>
                                <path d="M10.27 11.5404C9.92888 11.5404 9.646 11.2571 9.646 10.9154V6.74872C9.646 6.40705 9.92888 6.12372 10.27 6.12372C10.6111 6.12372 10.894 6.40705 10.894 10.9154C10.894 11.2571 10.6111 11.5404 10.27 11.5404Z"
                                      fill="var(--blg-color-primary500)"/>
                                <path d="M12.6742 2.95705H7.86517C7.53236 2.95705 7.26611 2.69038 7.26611 2.35705C7.26611 2.02372 7.53236 1.75705 7.86517 1.75705H12.6742C13.007 1.75705 13.2732 2.02372 13.2732 2.35705C13.2732 2.69038 13.007 2.95705 12.6742 2.95705Z"
                                      fill="var(--blg-color-primary500)"/>
                            </svg>
                            <span class="text-xs font-normal text-[#727272]"><?php echo BLOGINA_ReadEstimateTime::blg_read_estimate_time(get_the_content()) . ' ' . __('minutes reading', BLOGINA_TEXT_DOMAIN); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endwhile; wp_reset_postdata(); ?>
        <?php echo $this->enable_slider ? '</div>' : '';?>
        <?php if($this->enable_slider && $this->show_pagination) : ?>
            <div class="blog-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
        <?php endif; ?>
    </div>

    <div class="flex justify-center mt-4 md:hidden">
        <button onclick="showMoreItems(this, '#post-container .hidden-mobile', 'hidden-mobile')" aria-label="view all"
                class="blg-btn-secondary">
            <?php echo __('view all', BLOGINAC_TEXT_DOMAIN); ?>
        </button>
    </div>
</div>


<style>
    /* Hide posts after the 4th one on mobile */
    @media (max-width: 767px) {
        .hidden-mobile {
            display: none;
        }
    }
</style>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            navigation: {
                nextEl: '.blog-<?php echo esc_attr($unique_id); ?>-button-next',
                prevEl: '.blog-<?php echo esc_attr($unique_id); ?>-button-prev',
            },
            pagination: {
                el: '.blog-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1024: { slidesPerView: <?php echo esc_attr($this->columns_lg); ?> },
                1025: {slidesPerView: <?php echo esc_attr($this->columns); ?>}
            },
        });
    </script>
<?php endif; ?>
